

 
/***********************************************************************************************
 *                                                                                             *
 *                        Example_1. ET-REMOTE MP3 COMMAND-Mode By Sent Command                *
 *                                                                                             *
 ***********************************************************************************************
 *                                                                                             *											                                                                *
 * Target MCU     : AT89C51RE2 (CP-JR51RE2 V1.0)                                               *
 * Editor         :  uvision3 3.62c                                                            *       
 * Compiler       : Keil C51 (V8.05 a)                                                         *
 *															                                   *
 * Port Interface :      																	   *
 *                                                                                             *
 *                : # MCU-89C51RE2 #                 # ET-REMOTE MP3 V2 #                       *
 *                  --------------                  --------------------                       *
 * UART0(RS232#1) :    P3.0(RX0)        Connect             Tx                                 *
 *                     P3.1(TX0)        Connect             Rx                                 *
 *                     GND              Connect             GND                                *
 *                     BAUD RATE 9600                                                          *  
 *              5V                                                                             *
 *             -+-                                                                             *
 *              |                                                                              *
 *              +------------------+                                                           *
 *              |                  |                                      -DIP SW.MODE         *
 *              |                  |                                       S1=ON ; S2=ON       *
 *              |                  |                 ET-REMOTE MP3 V2     -DIP SW.CONFIG       *
 *       +------+------+           |               +-------------------+   S1=ON ; S2=OFF      *
 *       |             |       +---+---+   +---+   |                   |   BR:9600             *
 *       |             |       |       |   |   |   |RS232(have-Max232) |                       *
 *       |             | RX0   |       |   |   |   |----+              |                       *
 *       |         P3.0+-------|RxI RxO|<--|-+ +-->|*Rx||              |        /|             *   
 *       |             | TX0   |       |   | |     |   ||              |      /  |             *
 *       |         P3.1+-------|TxI TxO|---+ +-----|*Tx||              +----||   |             *
 *       |             |       |       |           |   ||              |    || SP|             *
 *       |             |       |MAX232 |       +---+*G ||              +----||   |             *
 *       |             |       +---+---+       |   |----+   [Power]    |      \  |             *
 *       |   89C51RE2  |           |           |   |                   |        \|             * 
 *       +------+------+           |           |   |         G  5V     |                       *
 *              |                  |           |   +---------+---+-----+                       * 
 *              |                  |           |             |   |                             *
 *              +------------------+-----------+             |   +--->5V                       *
 *              |                                            |                                 *
 *            --+--                                        --+--                               *
 *             ---                                          ---                                *
 *              -                                            -                                 *
 *                                                                                             *
 * Test Operate    : For Test Program in Micro SD Card must have number File 15 File           *
 *                   Play File Numbe 1 once and Play Repeat File Number 2-15                   *
 *                                                                                             *
 * Last Update     : 28/May/2012                                                               *  
 * Create By       : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                      *
 *                                                                                             *
 ***********************************************************************************************/


 #include <at89c51xd2.h>
 #include <stdio.h>


 char num_hi,num_lo  ;       //Keep Ascii byte high and low

/***********************************************
 *                  Function Delay 		       *
 ***********************************************/
 void delay(int cnt)
 {
  int i,j ;
  
      for(i=0;i<cnt;i++)
	    for(j=0;j<cnt;j++);
 }


 
 /********************************************
  *              Initial UART0               *
  ********************************************/

 void UART0_Init(void)
  {

   BDRCON |= 0x1C  ;  // Select Internal Baud-Rate,enable,0x1E=Fast //0x1C=No fast 	 
   SCON    = 0x50  ;  // Serial Mode1:8bit Uart,enable serial ,Clear Flag Rx/Tx 	   
   ES      = 0     ;  //Disable Serial Uart  Interrupt    
  
   BRL     = 0x88  ;  // Baud Rate 9600
   PCON   |= 0x80  ;  // Set SMOD1=1 :Double BR  
   BDRCON |= 0x02  ;  // Set SPD  =1 :Fast BR  
  
  }


/*************************************************************************************
 **                 Check Respond Command & End of Fili From Board MP3              **
 *************************************************************************************/

//-------------- Check Echo Command (#OK)----------------

void Echo_Cmm()
 {
   char buf_cmm[2] ;
   char n,ch ;
   
   do
    {
      do
       {
         while(RI==0){;}                  //Check Flag Rx if RI =1 Have data
         ch = SBUF 				        ; //Read Data
		 RI = 0                         ; //Clear Flag Rx
       }while(ch != '#')                ; //Check Byte Start of Echo cmm('#')

      for(n=0;n<2;n++)                    //if ch = # then Keep cmm 2 byte(Keep 'OK')
       {
         while(RI==0){;}                ; //Check Flag Rx if RI =1 Have data
         buf_cmm[n] = SBUF              ; //Keep Data 'OK' 
		 RI = 0                         ; //Clear Flag Rx
       }
     
    }while((buf_cmm[0]!='O')&&(buf_cmm[1]!='K')) ; //Check Echo Command = 'OK' Exit Loop
 }



//-------------- Check Echo End Of File(&E) ---------------

void Echo_EOF()
 {  
   unsigned char eof,ch ;
   
   do
    {
      do
       {
         while(RI==0){;}                      ;  //Check Flag Rx if RI =1 Have data
         ch = SBUF                            ;  //Read Data
         RI = 0  ;
	   }while(ch != '&')                      ;  //Check Byte Start of Echo EOF('&')

       while(RI==0){;}                        ;  //Check Flag Rx if RI =1 Have data
       eof = SBUF                             ;  //Read Data 
       RI = 0   		                      ;  //Clear Flag Rx

    }while(eof!='E')                          ;  //Check Echo EOF = 'E' Exit loop
 }


//--------------- Convert Dec(01-99) To Ascii 2 Colume  --------------------

void Dec_to_Ascii(char num_fi)
 {
   if(num_fi <= 99)
    {
      num_hi = (num_fi/10)+0x30   ; //Convert to Ascii Byte High
      num_lo = (num_fi%10)+0x30   ; //Convert to Ascii Byte Low 
    }
 }



/**********************************************************************
 **                                                                  **
 **                         main Program                             **
 **                                                                  **
 **********************************************************************/
 
 int main(void) 
  {
    char num,enter  = 0x0D  ;

    UART0_Init()                   ;
    delay(800)                     ;  //delay for Sync Borad MP3 Ready 

    //------------------- Begin Sent Command --------------------

    TI = 1                         ;   //Set Flag TI=1 for Start sent data
    printf("*CF=000%c",enter)      ;   //Sent CMM Config. Play[000] =0:Play Instantly ,0:Play 1 Round ,0:Not Display Time
    while(TI == 0){;}	               //Check Flag TI=1 Sent data Ready Exit loop 
    TI=0                           ;   //Clear Flag TI

	Echo_Cmm()                     ;   //Check CMM'#OK'
  

	TI=1                           ;   //Set Flag TI=1 for Start sent data
    printf("*VL=60%c",enter)       ;   //Sent CMM Set Volum='60'
	 while(TI == 0){;}	               //Check Flag TI=1 Sent data Ready Exit loop 
    TI=0                           ;   //Clear Flag TI

    Echo_Cmm()                     ;   //Check CMM'#OK'

	TI = 1                         ;   //Set Flag TI=1 for Start sent data
    printf("*P1=01%c",enter)       ;   //Sent CMM Play File by Number :Start File #1
    while(TI == 0){;}	               //Check Flag TI=1 Sent data Ready Exit loop 
    TI=0                           ;   //Clear Flag TI

    Echo_Cmm()                     ;   //Check CMM'#OK'
    Echo_EOF()                     ;   //Check End of File
    

   //------------- Loop Play file Number #2-#15 Repeat All  -----------
    
   num = 2                                      ;  //Value for Number Song Decimal
   while(1)
     {

      Dec_to_Ascii(num)                         ;   //Convert Number File to Ascii

	  TI=1                                      ;    //Set Flag TI=1 for Start sent data
      printf("*P1=%c%c%c",num_hi,num_lo,enter)  ;    //Sent CMM Play File by Number :Start File #2
      while(TI == 0){;}	                             //Check Flag TI=1 Sent data Ready Exit loop 
      TI=0                                      ;	 //Clear Flag TI
	 
	  Echo_Cmm()                                ;   //Check CMM'#OK'
      Echo_EOF()                                ;   //Check End of File
      num++                                     ;   //Increment Next Number File
 
      if(num==16)                                   //Check File Last number 15
       num = 2                                  ;   //New Start File Number 2 
     }    
 
  }




















